*_______________________________
*
* 2. Atheoretical (ARMA) Model
*_______________________________

use 01_rep.dta
local b=572 //Estimation: if date<=572 (2007m10)
/* Within sample: if date>=573
Out of sample: if date>=584 is sept2008, 539=dec2004; 551=dec2005; 563=dec2006 */

* 1. Estimate Model
arima fadopt if date<=`b', ar(12) ma(4 5 6 7 9 10 12) nolog

eststo 
estat ic
matrix gofm1=r(S)'

predict resid1 if date<=`b', resid
label variable resid1 "SARMA Residuals"

predict y_arma_1 if date<`b', xb
label variable y_arma_1 "SARMA-predicted values"

* 2. Within-sample Forecast
predict yhat_ws if date>=`b', xb
predict mse_ws if date>=`b', mse
predict y_fc_ws //, dynamic(`b')
label variable y_fc_ws "Within-sample forecast"

* 3. Compute Theil's U, i.e. compare the forecast errors with a naive forecast
* A. Numerator: SUM of Squared errors model: observed y_t-predicted y_t
gen suemod_2=(fadopt-y_fc_ws)^2
label variable suemod_2 "squared residual model forecast"

* B. Denominator: Sum of squared errors naive forecast (the past observed value): observed y_t - previous value of y_t
gen suenaiv_2=(fadopt-L.fadopt)^2
label variable suenaiv_2 "squared residual naive forecast"

* C. Sum up and square across within sample forecasts
egen ssuemod_2=total(suemod_2) if date>=`b'
quietly su ssuemod_2
local num=r(mean)

egen ssuenaiv_2=total(suenaiv_2) if date>=`b'
quietly su ssuenaiv_2
local den=r(mean)
local U=sqrt(`num'/`den')
display `U'

* Mean squared prediction error
su suemod_2
local MSPE=r(mean)
display `MSPE'

* 4. Out-of-sample Forecast
local b=584
arima fadopt if date<=`b', ar(12) ma(4 5 6 7 9 10 12) nolog
*ar(12) ma(6 7 12) nolog 

* Enlarge dataset: 24 observations
quietly d
local newn=r(N)+24
set obs `newn'
gen aux=_n-r(N)
order aux

su date
replace date=r(max)+aux if date==.
drop aux

predict yhat_os if date>`b', xb
predict mse_os if date>`b', mse
predict y_fc_os, dynamic(`b')
label variable y_fc_os "Dynamic out-of-sample forecast"

save 02_rep.dta, replace
clear
exit